/*
 * Main.java
 *
 * Created on 29 June 2006, 16:09
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package rfabroker;



import java.util.*;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.db.*;
import com.hp.hpl.jena.ontology.*;
import com.hp.hpl.jena.rdf.model.*;
import javax.swing.DefaultListModel;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;

/**
 *
 * @author Markos Fragkakis
 */
public class Broker {
    
    OntModelSpec mySpec;
    BrokerInterface myBrokerInterface;
    ModelMaker myModelMaker;
    OntModel currentModel;
    ExtendedIterator rfaProfileIterator, resProfileIterator, availableResourcesIterator, modelMakerModelsIterator;
    DefaultListModel matchesListModel;
    
    
    
    /** Creates a new instance of Broker */
    public Broker() {
        
        // Create the Swing Interface
        myBrokerInterface = new BrokerInterface( this );
        myBrokerInterface.setVisible(true);
        
        print("Initializing...\n");
        
        
        
        
        // ************* DATABASE CONNECTION *************
        
        print("Database Initialization...");
        
        String className = "com.mysql.jdbc.Driver";        // path of driver class
        try{
            Class.forName (className);                         // Load the Driver
        } catch (ClassNotFoundException ex1) {
            print("Could Not Establish Database Connection");
        }
        
        String DB_URL =    "jdbc:mysql://localhost/rfa";   // URL of database 
        String DB_USER =   "rfa";                          // database user id
        String DB_PASSWD = "rfa";                          // database password
        String DB =        "MySQL";                        // database type
        
        
        // Create database connection
        //IDBConnection conn = new DBConnection ( DB_URL, DB_USER, DB_PASSWD, DB );
        print(" OK!\n");
        

        

        
        
        
        //************************************************
        //
        //           JENA INITIALIZATION 
        //
        //************************************************
        
        
        print("Jena Framework Initialization...");

        // Create Model Maker
        myModelMaker = ModelFactory.createMemModelMaker();
        // Create the specifications
        mySpec = new OntModelSpec( OntModelSpec.OWL_DL_MEM_RDFS_INF );
        //mySpec = new OntModelSpec( OntModelSpec.OWL_DL_MEM_RULE_INF ); //With inference UNCOMMENT LATER!!
        mySpec.setImportModelMaker(myModelMaker);
        mySpec.setBaseModelMaker(myModelMaker);
        
        //Create the new KB
        Model baseModel1 = myModelMaker.createModel("newKB");			
        currentModel = ModelFactory.createOntologyModel(mySpec, baseModel1 );
        
        // Create a Document Manager ??????
        //OntDocumentManager myDocumentManager = new OntDocumentManager();
        //mySpec.setDocumentManager( myDocumentManager );       
        // set the mgr's properties now
        //... some code ...
        // now use it
        
        
        // Enable Interface Buttons
       myBrokerInterface.addResourceButton.setEnabled(true);
       
       print(" OK!\n");


        
        
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        // TODO code application logic here
        Broker myBroker = new Broker();
    }
    
    
    
   
    
    
    //************************************************
    //
    //            FUNCTIONAL METHODS 
    //
    //************************************************
    
    
    
    public void addDocument(String documentURL) {
        Model newModel = myModelMaker.createModel(documentURL);
        
        OntModel newOntModel = ModelFactory.createOntologyModel(mySpec, newModel);        
        
        //newOntModel.begin();
        newOntModel.read(documentURL);
        //newOntModel.commit();
        
        //currentModel.begin();
        currentModel.addSubModel(newOntModel);
        //currentModel.commit();        
        
        print("Reading Resource document : " + documentURL + " OK! \n");
        
        refreshLoadedDocuments();
        refreshAvailableResources();
    }
    
    
    
    
    public void brokerRfa(String documentURL) {
        
        // Create a Default List Model (Netbeans did not create one...), fill it with information and display it.
        matchesListModel = new DefaultListModel();
       
        // Create a Model containing the RFA
        Model newModel = myModelMaker.createModel(documentURL);        
        OntModel newOntModel = ModelFactory.createOntologyModel(mySpec, newModel);
        newOntModel.read(documentURL);
        currentModel.addSubModel(newOntModel);
        
        // Get the RFA Profile...
        print("|-- Searching for RFA Profile Class.\n");
        OntClass rfaProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#rfaProfile");        
        if(rfaProfileClass != null) {
            
            rfaProfileIterator = rfaProfileClass.listInstances();
            if(rfaProfileIterator.hasNext()) {
                // ... which means the first RFA you find. 
                //(TODO: MAKE THE SELECTION FROM THE JLIST OF THE GUI)
                Individual rfaProfile = (Individual) rfaProfileIterator.next();
                print("|-- Brokering RFA : " + rfaProfile.getLocalName() + "\n");
                
                OntClass transportRfaProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#rfaTransportProfile");
                OntClass provideRfaProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#rfaProvideProfile");
                
                if(rfaProfile.hasRDFType(transportRfaProfileClass)) {
                    
                    brokerTransportRFA(rfaProfile);
                } else if (rfaProfile.hasRDFType(provideRfaProfileClass)) {
                    
                    brokerProvideRFA(rfaProfile);
                } else {
                    
                    brokerGenericRfa(rfaProfile);
                }
                
                
                
                
                
            } else {
                print("|-- There is no Profile Class in the loaded Documents!\n");
            }
        } else {
            print("|-- There is no Service Profile in the given URL\n");
        }      
    }
    
    
    
    
    
    
    //************************************************
    //
    //            TRANSPORT RFA BROKERING 
    //
    //************************************************
    
    
    void brokerTransportRFA ( Individual rfaProfile ) {
        
        // This method will broker a Transport RFA, and will print the result in the corresponding JList of the Interface
        
        print("|------ Brokering Transport RFA : " + rfaProfile.getLocalName() + "\n");
        
        //OntResource rfaDestinationResource = getDestinationLocationOntResource(rfaProfile);
        
        OntClass departurePointOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#DeparturePoint");
        OntClass destinationPointOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#DestinationPoint");
        OntClass weightInputOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#WeightInput");
        
        OntResource rfaDepartureLocationOntResource = getLocationOntResource4Direction(rfaProfile, departurePointOntClass);
        OntResource rfaDestinationLocationOntResource = getLocationOntResource4Direction(rfaProfile, destinationPointOntClass);        
        Individual rfaWeightInputIndividual = getProfileInput(rfaProfile, weightInputOntClass);
        
        Vector usedTransportersVector = new Vector();
        Vector emptyChainContainer = new Vector();
        
        //print("$$$$$$ rfaDepartureLocationOntResource " + rfaDepartureLocationOntResource.getLocalName() + " rfaDestinationLocationOntResource " + rfaDestinationLocationOntResource.getLocalName() +" rfaWeightInputIndividual " + rfaWeightInputIndividual.getLocalName() + "\n");
        
        Vector chainContainer = getChainsOfTransporters(rfaDepartureLocationOntResource, rfaDestinationLocationOntResource, rfaWeightInputIndividual, usedTransportersVector, emptyChainContainer);
        if(chainContainer.size()==0) {
            //print("NO MATCH!!");
        } else {
            printChainContainer(chainContainer);
        }
              
        
    }
    
    
    Vector getChainsOfTransporters (OntResource departureLocationOntResource, OntResource destinationLocationOntResource, Individual weightInputIndividual, Vector usedTransportersVector, Vector chainContainer) {
        
        
        print("|-------------- Looking for Transport Chain:\n");
        print ("|-------------- Ultimate Destination is :" + destinationLocationOntResource.getLocalName() + "\n");
        print ("|-------------- Starting Point is :" + departureLocationOntResource.getLocalName() + "\n");
        print ("|-------------- Current # of used Transporters : " + usedTransportersVector.size() + "\n");
        
        OntClass resourceTransportProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resTransportProfile");
        
        ExtendedIterator myResProfileIterator = resourceTransportProfileClass.listInstances();

        while(myResProfileIterator.hasNext()) {
            

            Individual currentResProfile = (Individual) myResProfileIterator.next();
            
            if (!usedTransportersVector.contains(currentResProfile)) {
            print ("|-------------- Checking Profile for Chain :" + currentResProfile.getLocalName() + "\n");
                // This resProfile must:
                // 1. Share the Ultimate Destination
                // 2. Share the Weight Restrictions
                // 3. Have a chain to the RFA Departure Point

                OntClass departurePointOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#DeparturePoint");
                OntClass destinationPointOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#DestinationPoint");
                OntClass weightInputOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#WeightInput");

                OntResource resDepartureLocationOntResource = getLocationOntResource4Direction(currentResProfile, departurePointOntClass);
                OntResource resDestinationLocationOntResource = getLocationOntResource4Direction(currentResProfile, destinationPointOntClass);        
                Individual resWeightInputIndividual = getProfileInput(currentResProfile, weightInputOntClass);           

                Boolean checkResult1 = compareOntResources (departureLocationOntResource, resDepartureLocationOntResource);
                Boolean checkResult3 = checkResourceForInput(weightInputIndividual, currentResProfile);
                Boolean checkResult2 = false;
                if (usedTransportersVector.size()==0) {
                    checkResult2 = compareOntResources (destinationLocationOntResource, resDestinationLocationOntResource);
                } else {
                    
                    checkResult2 = compareOntResources (resDestinationLocationOntResource, destinationLocationOntResource);
                }
                
                if(checkResult1) {
                    print ("|-------------- Resource has a matching Daparture Point\n");
                }
                if(checkResult2) {
                    print ("|-------------- Resource has a matching Dastination Point\n");
                }
                if(checkResult3) {
                    print ("|-------------- Resource respects Weight Restrictions\n");
                }
                
                if(checkResult2 && checkResult3) {
                    if(checkResult1) {
                        // BINGO!!!
                        usedTransportersVector.add(currentResProfile);
                        Vector clone = (Vector) usedTransportersVector.clone();
                        chainContainer.add(clone);
                        usedTransportersVector.remove(currentResProfile);
                    } else {
                        // We check if there is a chain from the rfaDeparturePoint to the currentRes departure Point
                        usedTransportersVector.add(currentResProfile);
                        chainContainer = getChainsOfTransporters(departureLocationOntResource, resDepartureLocationOntResource, weightInputIndividual, usedTransportersVector, chainContainer);
                        usedTransportersVector.remove(currentResProfile);
                        print ("|-------------- Ultimate Destination is AGAIN :" + destinationLocationOntResource.getLocalName() + "\n");
                        print ("|-------------- Current # of used Transporters is AGAIN : " + usedTransportersVector.size() + "\n");
                        
                    }
                }
            }
        }
        return chainContainer;
    }   

    
   
    
  
    
    //************************************************
    //
    //            PROVIDE RFA BROKERING
    //
    //************************************************    
    
    
      void brokerProvideRFA ( Individual rfaProvideProfile ) {
        
        print("|------ Brokering Providing RFA : " + rfaProvideProfile.getLocalName() + "\n");
          
        Vector chainContainer = brokerRfaDirectly (rfaProvideProfile);
        
        
        OntClass goodsInputClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#GoodsInput");
        OntClass resourceProvideProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resProvideProfile");
        OntClass resourceTransportProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resTransportProfile");
        OntClass destinationPointOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#DestinationPoint");
        
        Individual rfaGoodsInput = getProfileInput(rfaProvideProfile, goodsInputClass);
        Individual weightRestrictionInput = createWeightRestrictionInput (rfaProvideProfile);
        
        
        ExtendedIterator myResProfileIterator = resourceProvideProfileClass.listInstances();

        while(myResProfileIterator.hasNext()) {
            
            Individual currentResProfile = (Individual) myResProfileIterator.next();
                
            print("|---------- Checking Providing Resource Profile : " + currentResProfile.getLocalName() + "\n");
                // This resProfile must:
                // 1. Satisfy the goods needed
                // 2. Have a chain to the RFA Destination Point

            Individual resGoodsInput = getProfileInput(currentResProfile, goodsInputClass);
            Boolean checkResult1 = checkMatchOfInputs(rfaGoodsInput, resGoodsInput);
            
            //Boolean checkResult1 = checkResourceForInput(rfaGoodsInput, currentResProfile);
            if (checkResult1) {
                
                print("|---------- Profile satisfies Goods Input\n");
                
                
                OntResource rfaDestinationLocation = getLocationOntResource4Direction(rfaProvideProfile, destinationPointOntClass);
                OntResource resDestinationLocation = getLocationOntResource4Direction(currentResProfile, destinationPointOntClass);

                print("|---------- Checking for Chain from " + resDestinationLocation.getLocalName() + " to " + rfaDestinationLocation.getLocalName() +  "\n");
                
                Vector emptyVector = new Vector();
                
                Vector aChainContainer = getChainsOfTransporters (resDestinationLocation, rfaDestinationLocation, weightRestrictionInput, emptyVector, emptyVector);
                aChainContainer = addProfile2ChainContainer (aChainContainer, currentResProfile);
                chainContainer.addAll(aChainContainer);
            }

        }
        printChainContainer (chainContainer);
    }
    
    
    
    
    Individual createWeightRestrictionInput ( Individual rfaProvideProfile ) {
        
        OntClass goodsInputClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#GoodsInput");
        OntClass weightInputClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#ExWeightInput");
        OntProperty requestQuantityProperty = currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#requestQuantity");
        OntProperty requestGoodTypeProperty = currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#requestGoodInput"); // TODO: change name
        OntProperty hasWeightProperty = currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#hasWeight");
        OntProperty hasWeightMeasureUnitProperty = currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#hasWeightMeasureUnit");
        
        
        // Get the number of items
        Individual goodsInput = getProfileInput(rfaProvideProfile, goodsInputClass);
        RDFNode goodsQuantityNode = goodsInput.getPropertyValue(requestQuantityProperty);
        Literal goodsQuantityLiteral = (Literal) goodsQuantityNode.as(Literal.class);
        int goodsQuantity = goodsQuantityLiteral.getInt();
        
        // Get the weight of item type
        RDFNode goodsTypeNode = goodsInput.getPropertyValue(requestGoodTypeProperty);
        Literal goodsTypeLiteral = (Literal) goodsTypeNode.as(Literal.class);
        String goodsTypeString = (String) goodsTypeLiteral.getValue();
        Individual goodsType = currentModel.getIndividual(goodsTypeString);
        
        RDFNode goodsTypeWeightNode = goodsType.getPropertyValue(hasWeightProperty);
        Literal goodsTypeWeightLiteral = (Literal) goodsTypeWeightNode.as(Literal.class);
        int goodsTypeWeight = goodsTypeWeightLiteral.getInt();
        
        // Create combined weight Literal
        int combinedWeight = goodsQuantity * goodsTypeWeight;
        Literal combinedWeightLiteral = currentModel.createTypedLiteral(combinedWeight, XSDDatatype.XSDnonNegativeInteger );

        // Get Measure Unit
        RDFNode weightMeasureUnitNode = goodsType.getPropertyValue(hasWeightMeasureUnitProperty);
        
        
        // Construct the Weight Restriction Input
       
        
        Individual weightRestrictionInput = weightInputClass.createIndividual("aWeightRestrictionInput");
        weightRestrictionInput.addProperty(hasWeightMeasureUnitProperty, weightMeasureUnitNode);
        weightRestrictionInput.addProperty(hasWeightProperty, combinedWeightLiteral);
        
        return weightRestrictionInput;
    }
    
  
    
    
    
    
    
    //************************************************
    //
    //            GENERIC RFA BROKERING
    //
    //************************************************     
    
    void brokerGenericRfa (Individual rfaProfile) {
        
        // This method will find direct matching between the RFA and the Resources, if any.
        // The matches will be added to the corresponding JList, in the Interface.
            
        print("|------ Brokering Generic RFA : " + rfaProfile.getLocalName() + "\n");
        
        Vector chainContainer = brokerRfaDirectly (rfaProfile);
        printChainContainer (chainContainer);
    }
    
    Vector brokerRfaDirectly (Individual rfaProfile) {
        
        print("|---------- Brokering RFA Directly : " + rfaProfile.getLocalName() + "\n");
        
        Vector chainContainer = new Vector();
        
        // List all available resource Profiles
        OntClass resourceProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resProfile");
        if(resourceProfileClass != null) {

            resProfileIterator = resourceProfileClass.listInstances();

            //For every one of the Profiles (available resources) returned ...
            int debugCount = 1;
            while(resProfileIterator.hasNext()) {
                
                Individual currentResProfile = (Individual) resProfileIterator.next();
                print("|-------------- Checking Profile  : " + currentResProfile.getLocalName() + "\n");
                Boolean checkResult = checkMatchOfProfiles(rfaProfile, currentResProfile);

                if (checkResult) {
                    Vector chainVector = new Vector();
                    chainVector.add(currentResProfile);
                    chainContainer.add(chainVector);
                }
                debugCount ++;

            }
            
        } else {
            //print("|-- resourceProfileClass is null in the RFA Model\n");
        }
        
        return chainContainer;
    }


    
    
    Boolean checkMatchOfProfiles(Individual rfaProfile, Individual resProfile) {

        // The two profiles will match if for every Input of the RFA there is one matching input in the Resource.
        // We will successively check all inputs, and only if there is a matching input for all of those, only then will this methid return true.
        
        print("|------------------ Comparing Profiles : " + rfaProfile.getLocalName() + " VS " + resProfile.getLocalName() + "\n");
        
        Property hasInputProperty = currentModel.getProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        ExtendedIterator rfaHasInputValuesIterator = rfaProfile.listPropertyValues(hasInputProperty);
        while(rfaHasInputValuesIterator.hasNext()) {
            // Take the current Input and check if there is a matching Input in the resource Profile.
            RDFNode currentRfaInputNode = (RDFNode) rfaHasInputValuesIterator.next();
            Individual currentRfaInputIndividual = (Individual) currentRfaInputNode.as(Individual.class);
            
            print("|---------------------- Looking in Profile for Input : " + currentRfaInputIndividual.getLocalName() + "\n");
            Boolean matchResourceInput = checkResourceForInput(currentRfaInputIndividual, resProfile);
            if (!matchResourceInput) {
                print("|---------------------- Input NOT Present in Profile!\n");
                return false;
            }
        }
        //print("|---- MATCH: " + rfaProfile.getLocalName() + " matches " + resProfile.getLocalName() + "\n");
        return true;
    }
    
    
    
    
    Boolean checkResourceForInput (Individual rfaInput, Individual resProfile) {
  
        // The method will succeed only if for rfaInput there is a matching input in the resProfile.
        // This will be checked by comparing successively all Inputs if the Profile to rfaInput.
        
        print("|-------------------------- Looking in Profile " + resProfile.getLocalName() + " for equivalent Input of : " + rfaInput.getLocalName() + "\n");
                 
        Property hasInputProperty = currentModel.getProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        ExtendedIterator resHasInputValuesIterator = resProfile.listPropertyValues(hasInputProperty);
        while(resHasInputValuesIterator.hasNext()) {

            RDFNode currentResInputNode = (RDFNode) resHasInputValuesIterator.next();
            Individual currentResInputIndividual = (Individual) currentResInputNode.as(Individual.class);
            Boolean tempInputsMatch = checkMatchOfInputs(rfaInput, currentResInputIndividual);
            if(tempInputsMatch) {
                print("|-------------------------- Found equivalent Inputs! : " + rfaInput.getLocalName() + " <------> " + currentResInputIndividual.getLocalName() + "\n");
                return true;
            }
        }
        print("|-------------------------- NO equivalent Input.\n");
        return false;
    }
    
    
    
    
    Boolean checkMatchOfInputs (Individual rfaInput, Individual resInput) {
        
        // This method will return true if the rfaInput and resInput match. That is if *ALL* the following are met:        
        // 1. They are of the same or subsumed type
        // 2. They contain the same Properties
        // 3. They have same or subsumed values in those Properties (Next method)
        
        print("|------------------------------ Comparing Inputs " + rfaInput.getLocalName() + " VS " + resInput.getLocalName() + "\n");
        
        OntClass rfaInputType = (OntClass) rfaInput.getRDFType(true).as(OntClass.class);
        OntClass resInputType = (OntClass) resInput.getRDFType(true).as(OntClass.class);
             
        // Check for point 1.
        // (If RFA and Res Inputs are of the same type)
        if (rfaInputType.hasSuperClass(resInputType)) {
            
            print("|---------------------------------- Point 1: Type match : " + rfaInputType.getLocalName() + " <-----> " + resInputType.getLocalName() +"\n");
            
            // We need all properties, except the type ones.        
            ExtendedIterator rfaInputStatements = rfaInput.listProperties();
            OntProperty typeOntProperty = currentModel.getOntProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
            
            while (rfaInputStatements.hasNext()) {
                
                Statement rfaInputTempStatement = (Statement) rfaInputStatements.next();                
                OntProperty rfaInputTempProperty = (OntProperty) rfaInputTempStatement.getPredicate().as(OntProperty.class);
                if (!typeOntProperty.equals(rfaInputTempProperty)) {
                    if (resInput.hasProperty(rfaInputTempProperty)) {
                        print("|---------------------------------- Point 2: Resource : " + resInput.getLocalName() + " has Property " + rfaInputTempProperty.getLocalName() +"\n");
                        Boolean checkResult = checkRfaPropertyValueAgainstResPropertyValue (rfaInput, rfaInputTempProperty, rfaInput.getPropertyValue(rfaInputTempProperty), resInput, resInput.getPropertyValue(rfaInputTempProperty));
                        if (!checkResult) {
                            print("|---------------------------------- Point 3: Input Property Values MISmatch.\n");
                            return false; // Because some property had non matching Values
                        }
                        print("|---------------------------------- Point 3: Values in this property Match for both Profiles\n");
                    } else {
                        print("|---------------------------------- Point 2: Input MISmatch : Property " + rfaInputTempProperty.getLocalName() +" Missing\n");
                        return false; // Because some property is not present in the Resource
                    }
                }
            }
            return true;
            
        } else {
            print("|---------------------------------- Point 1: Type MISmatch : " + rfaInputType.getLocalName() +" IS NOT " + resInputType.getLocalName() +"\n");
            return false; // Because of non matching type of Inputs
        }       
    }
    
    
    
    Boolean checkRfaPropertyValueAgainstResPropertyValue (Individual firstInput, OntProperty firstInputTempProperty, RDFNode firstInputPropertyValueNode, Individual secondInput, RDFNode secondInputPropertyValueNode) {
        
        // This method will return true if the Values match.
        // Whether there is match or not is determined by the particular type of Input.
        
        print("|-------------------------------------- Comparing Property Value VS Property Value: " + firstInputPropertyValueNode.toString() + " VS " + secondInputPropertyValueNode.toString() + " for Input " + firstInput.getLocalName() + "\n");
        
        if(firstInputPropertyValueNode.isLiteral() && secondInputPropertyValueNode.isLiteral()) {
            // If they are literals, convert them to resources and then compare.
 
            print("|-------------------------------------- Both Input Property Values are literals\n");
            Literal rfaInputPropertyValueLiteral = (Literal) firstInputPropertyValueNode.as(Literal.class);
            Literal resInputPropertyValueLiteral = (Literal) secondInputPropertyValueNode.as(Literal.class);
            
            OntClass boundInputOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#BoundInput");
            
            if (firstInput.hasRDFType(boundInputOntClass) && (rfaInputPropertyValueLiteral.getDatatypeURI().equals("http://www.w3.org/2001/XMLSchema#nonNegativeInteger"))) {
                
                // If our Literals are Bound Literals, they need special comparison                
                Boolean checkResult = compareBoundLiterals(firstInput, firstInputTempProperty, rfaInputPropertyValueLiteral, secondInput, resInputPropertyValueLiteral);
                return checkResult;
            } else {
                
                // else the InputPropertyValuesLiterals are actually URIs of Resources
                
                OntResource rfaInputPropertyValueLiteral2Resource = currentModel.getOntResource(rfaInputPropertyValueLiteral.getValue().toString());
                OntResource resInputPropertyValueLiteral2Resource = currentModel.getOntResource(resInputPropertyValueLiteral.getValue().toString());

                Boolean checkResult = compareOntResources (rfaInputPropertyValueLiteral2Resource, resInputPropertyValueLiteral2Resource);
                return checkResult;
            }
            
            
        } else if (firstInputPropertyValueNode.isResource() && secondInputPropertyValueNode.isResource()) {
            // If they are resources, compare them.
        
            OntResource rfaInputPropertyValue = (OntResource) firstInputPropertyValueNode.as(OntResource.class);
            OntResource resInputPropertyValue = (OntResource) secondInputPropertyValueNode.as(OntResource.class);

            Boolean checkResult = compareOntResources (rfaInputPropertyValue, resInputPropertyValue);
            return checkResult;
        } 
        
        // Else
        print("|-------------------------------------- Property Values MISmatch\n");
        return false;
    }
    
    
    Boolean compareOntResources (OntResource firstResource, OntResource secondResource) {
        // This method compares two Ont Resources. It succeeds if:
        // 1. they are both the same Individual
        // 2. if they are both classes and the first is a suclass of the second
        // 3. If the first is an Individial, the second is a Class, and the Individual is an Instance of that Class.
        
        print("|-------------------------------------- Comparing Resources " + firstResource.toString() + " AND " + secondResource.toString() + "\n");
        
        if (firstResource.equals(secondResource)) {
            // Check for condition 1.
            
             print("|-------------------------------------- Resources match...\n");
            return true;
        } else if (firstResource.isClass() && secondResource.isClass()) {
            // Check for condition 2.

            OntClass firstResourceClass = (OntClass) firstResource.as(OntClass.class);
            OntClass secondResourceClass = (OntClass) secondResource.as(OntClass.class);

            if (firstResourceClass.hasSuperClass(secondResourceClass)) {
                 print("|-------------------------------------- Resources match...\n");
                return true;
            }
        } else if (firstResource.isIndividual() && secondResource.isClass()){
            // Check for condition 3.

            Individual firstResourceIndividual = (Individual) firstResource.as(Individual.class);
            OntClass secondResourceClass = (OntClass) secondResource.as(OntClass.class);

            if (firstResourceIndividual.hasRDFType(secondResourceClass)) {
                 print("|-------------------------------------- Resources match...\n");
                return true;
            }
            
        }
        print("|-------------------------------------- Resources mismatch...\n");
        return false;
    }
    
    
    
    
    Boolean compareBoundLiterals (Individual firstInput, OntProperty someInputProperty, Literal firstLiteral, Individual secondInput, Literal secondLiteral) {
    
        OntClass minimumBoundInputOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#MinimumBoundInput");
        OntClass maximumBoundInputOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#MaximumBoundInput");
        OntClass exactBoundInputOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#MaximumBoundInput");
        
        print("|------------------------------------------ Comparing Bound Literals : FirstInput is " + firstInput.getLocalName() + " and Second Input is " + secondInput.getLocalName() + "\n");
        
        if ((firstInput.hasRDFType(minimumBoundInputOntClass)) && ((firstInput.hasRDFType(minimumBoundInputOntClass)) || (firstInput.hasRDFType(exactBoundInputOntClass))) && (firstLiteral.getInt() >= secondLiteral.getInt())) {

            print("|------------------------------------------ Bound Literals Match\n");
            return true;
        }
        if ((secondInput.hasRDFType(maximumBoundInputOntClass) && ((firstInput.hasRDFType(maximumBoundInputOntClass)) || (firstInput.hasRDFType(exactBoundInputOntClass))) && (firstLiteral.getInt() <= secondLiteral.getInt()))) {
            
            print("|------------------------------------------ Bound Literals Match\n");
            return true;
        }
        print("|------------------------------------------ Bound Literals MISMatch\n");
        return false;
    }


    
    
    
    
    
    
    
    
    
  
    
    
    //************************************************
    //
    //            INPUT HANDLING METHODS
    //
    //************************************************         
    
    
    Individual getLocationInput4Direction(Individual someProfile, OntClass desiredDirectionOntClass) {
        
        // This method takes a Profile and a Direction and returns the Input the Profile about that Direction.
                
        OntProperty hasInputProperty = currentModel.getOntProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        OntProperty hasDirectionProperty = currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#hasDirection");
        OntClass locationInputOntClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#InputLocation");
        
        
        ExtendedIterator profileInputValuesIterator = someProfile.listPropertyValues(hasInputProperty);
        while(profileInputValuesIterator.hasNext()) {

            RDFNode currentProfileInputNode = (RDFNode) profileInputValuesIterator.next();
            Individual currentProfileInputIndividual = (Individual) currentProfileInputNode.as(Individual.class);
            
            if (currentProfileInputIndividual.hasRDFType(locationInputOntClass)) {
                // If there this is a location input, we check if it is a _Desired Direction_ Location Input.
                
                RDFNode directionLiteralNode = currentProfileInputIndividual.getPropertyValue(hasDirectionProperty);
                Literal directionLiteral = (Literal) directionLiteralNode.as(Literal.class);
                OntClass directionOntClass = currentModel.getOntClass(directionLiteral.getValue().toString());
                
                if(directionOntClass.hasSuperClass(desiredDirectionOntClass)) {
                    return currentProfileInputIndividual;
                }
            }           
        }
        return null;
    }
    
         
           
   
   OntResource getLocationOntResource4Direction(Individual someProfile, OntClass desiredDirectionOntClass) {
        
        OntProperty hasLocationProperty = currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#hasLocation");

        Individual rfaDirectionLocationInput = getLocationInput4Direction(someProfile, desiredDirectionOntClass);
        
        RDFNode profileDirectionLiteralNode = rfaDirectionLocationInput.getPropertyValue(hasLocationProperty);
        Literal profileDirectionLiteral = (Literal) profileDirectionLiteralNode.as(Literal.class);
        OntResource directionOntResource = currentModel.getOntResource(profileDirectionLiteral.getValue().toString());

        return directionOntResource;
    }
    
    
        
    
    Individual getProfileInput(Individual someProfile, OntClass inputTypeOntClass) {
        
        OntProperty hasInputProperty = currentModel.getOntProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        
        
        ExtendedIterator profileInputValuesIterator = someProfile.listPropertyValues(hasInputProperty);
        while(profileInputValuesIterator.hasNext()) {

            RDFNode currentProfileInputNode = (RDFNode) profileInputValuesIterator.next();
            Individual currentProfileInputIndividual = (Individual) currentProfileInputNode.as(Individual.class);
            
            if (currentProfileInputIndividual.hasRDFType(inputTypeOntClass)) {
                // If there this is a location input, we check if it is a _Destination_ Location Input.
                
                return currentProfileInputIndividual;
            }           
        }
        return null;        
    }

    
    
    
    
  
    //************************************************
    //
    //            UPDATE GUI METHODS
    //
    //************************************************            
    
    
    void refreshLoadedDocuments() {
        
        print("|-- Refreshing Loaded Documents List...");
        
        // Create a Default List Model (Netbeans did not create one...), fill it with information and display it.
        DefaultListModel tempModel1 = new DefaultListModel();

        //modelMakerModelsIterator = myModelMaker.listModels();
        
        modelMakerModelsIterator = currentModel.listClasses();
        
        while(modelMakerModelsIterator.hasNext()) {
            tempModel1.addElement( (String) modelMakerModelsIterator.next().toString());
        }
        myBrokerInterface.loadedDocumentsList.setModel(tempModel1);
        myBrokerInterface.loadedDocumentsList.repaint();
        
        print(" OK!\n");
    }
    
    
    
    void refreshAvailableResources() {
        
        print("|-- Refreshing Available Resources List...\n");
        
        // Create a Default List Model (Netbeans did not create one...), fill it with information and display it.
        DefaultListModel tempModel2 = new DefaultListModel();
      
        print("|-- Getting Profile Class \n");
        OntClass resourceProfileClass = currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resProfile");
        print("|-- Checking if Profile class is inserted... \n");
        if(resourceProfileClass == null)
            print("|-- resourceProfileClass is null \n");
        else {
            print("|-- Listing Profile instances... ");
            //myExtendedIterator1 = currentModel.listClasses();
            availableResourcesIterator = resourceProfileClass.listInstances();
            while(availableResourcesIterator.hasNext()) {
                Individual tempAvailableResourceInstance = (Individual) availableResourcesIterator.next();
                tempModel2.addElement(tempAvailableResourceInstance.getLocalName());
            }
            myBrokerInterface.availableResourcesList.setModel(tempModel2);
            myBrokerInterface.availableResourcesList.repaint();
        }
        print("OK!\n");
        
    }
    
    
       
    public void print(String aString) {
        System.out.println(aString);
        myBrokerInterface.jTextArea2.append(aString);
        myBrokerInterface.jTextArea2.repaint();
    }
    
    
    
    void printChainContainer (Vector chainContainer) {
        int currentIndex = chainContainer.size() - 1;
        while (currentIndex >= 0) {
            Vector currentChain = (Vector) chainContainer.get(currentIndex);
            printChain(currentChain);
            currentIndex --;
        }
    }
    
    
    
    void printChain (Vector chainVector) {
        String chainString = new String();
        if (chainVector.size() > 1) {
        chainString = chainString.concat("Chain : ");    
        }
        
        int currentIndex = chainVector.size() - 1;
        
        while (currentIndex > 0) {
            Individual currentProfile = (Individual) chainVector.get(currentIndex);
            chainString =  chainString.concat(currentProfile.getLocalName() + " --> ");
            currentIndex --;
        }
        Individual currentProfile = (Individual) chainVector.get(0);
        chainString = chainString.concat(currentProfile.getLocalName());
        
        matchesListModel.addElement(chainString);

        myBrokerInterface.matchesList.setModel(matchesListModel);
        myBrokerInterface.matchesList.repaint();
        print(chainString);
        
    }
    
    Vector addProfile2ChainContainer (Vector chainContainer, Individual resProfile) {
        
        int currentIndex = chainContainer.size() - 1;
        while (currentIndex >= 0) {
            Vector tempChain = (Vector) chainContainer.get(currentIndex);
            tempChain.add(resProfile);
            currentIndex --;
        }
        return chainContainer;
    }
    
}




